
Option Explicit

' Application control variables
Dim miButton As Integer      ' Button pressed to end a dialog
Dim msAppName As String      ' Application name

Function GetAppName () As String

    ' FUNCTION:   GetAppName()
    '
    ' PURPOSE:    This function operates in cooperation with SetAppName()
    '             and should be used on all MsgBox calls to provide the
    '             caption parameter
    '
    ' PARAMETERS: None
    '
    ' RETURNS:    The application name as a string

    GetAppName = msAppName

End Function

Function GetButton () As Integer

    ' FUNCTION:   GetButton()
    '
    ' PURPOSE:    This function should be used in code outside of a
    '             dialog to determine which button terminated the dialog
    '
    ' PARAMETERS: None
    '
    ' RETURNS:    The value previously set by the SetButton() function

    GetButton = miButton

End Function

Sub Main ()

    SetAppName "SpellChecker Demo"

    ' Start up the application
    Load frmMain
    frmMain.Show
    DoEvents        ' Required so that events occur in right order

End Sub

Sub SetAppName (ByVal vsName As String)

    ' FUNCTION:   SetAppName()
    '
    ' PURPOSE:    According to the Microsoft user interface design
    '             guidelines and the CUA standard, all message boxes
    '             which appear to prompt or warn the user should have
    '             the application name as the caption. This is so that
    '             in a multi-tasking environment such as Windows, if a
    '             message box appears, the use knows which application
    '             it is refering to.
    '             This function stores the name of the application and
    '             should be called once at the start up of an application
    '
    ' PARAMETERS: The application name as a string
    '
    ' RETURNS:    None

    msAppName = vsName

End Sub

Sub SetButton (riBtn As Integer)

    ' FUNCTION:   SetButton()
    '
    ' PURPOSE:    This function should be used in the command button
    '             processing of dialogs to provide a means of passing
    '             back the button which was pressed to exit a dialog
    '
    ' PARAMETERS: An integer flag specifying which button was used to
    '             terminate a dialog. The values used are at the
    '             discression of the programmer
    '
    ' RETURNS:    None

    miButton = riBtn

End Sub

